import os
import sys
import subprocess

# Установка зависимостей
def install_package(package):
    subprocess.check_call([sys.executable, "-m", "pip", "install", package])

required_packages = ["requests", "ntplib", "pytz", "urllib3", "icmplib", "colorama", "linecache"]
for package in required_packages:
    try:
        __import__(package)
    except ImportError:
        print(f"Устанавливаем пакет {package}...")
        install_package(package)

os.system('cls' if os.name == 'nt' else 'clear')

import random
import time
import hashlib
import linecache
from datetime import datetime, timezone, timedelta
import ntplib
import pytz
import urllib3
import json
import statistics
from icmplib import ping
from colorama import init, Fore, Style
import requests
import threading
from queue import Queue
import re
import ctypes

# Инициализация colorama
init(autoreset=True)

# Цвета для вывода
col_g = Fore.GREEN
col_gb = Style.BRIGHT + Fore.GREEN
col_b = Fore.BLUE
col_bb = Style.BRIGHT + Fore.BLUE
col_y = Fore.YELLOW
col_yb = Style.BRIGHT + Fore.YELLOW
col_r = Fore.RED
col_rb = Style.BRIGHT + Fore.RED

# Глобальные переменные
ntp_servers = [
    "ntp0.ntp-servers.net", "ntp1.ntp-servers.net", "ntp2.ntp-servers.net",
    "ntp3.ntp-servers.net", "ntp4.ntp-servers.net", "ntp5.ntp-servers.net",
    "ntp6.ntp-servers.net"
]

MI_SERVERS = ['161.117.96.161', '20.157.18.26']

# Функция очистки экрана
def clear_screen():
    os.system('cls' if os.name == 'nt' else 'clear')

# Функции из UPR
def generate_device_id():
    random_data = f"{random.random()}-{time.time()}"
    device_id = hashlib.sha1(random_data.encode('utf-8')).hexdigest().upper()
    return device_id

def get_initial_beijing_time():
    client = ntplib.NTPClient()
    beijing_tz = pytz.timezone("Asia/Shanghai")
    for server in ntp_servers:
        try:
            print(col_y + f"\nОпределение текущего времени в Пекине" + Fore.RESET)
            response = client.request(server, version=3)
            ntp_time = datetime.fromtimestamp(response.tx_time, timezone.utc)
            beijing_time = ntp_time.astimezone(beijing_tz)
            print(col_g + f"[Пекинское время]: " + Fore.RESET + f"{beijing_time.strftime('%Y-%m-%d %H:%M:%S.%f')}")
            return beijing_time
        except Exception as e:
            print(f"Ошибка подключения к {server}: {e}")
    print(f"Не удалось подключиться ни к одному из NTP серверов.")
    return None

def get_synchronized_beijing_time(start_beijing_time, start_timestamp):
    elapsed = time.time() - start_timestamp
    current_time = start_beijing_time + timedelta(seconds=elapsed)
    return current_time

def wait_until_target_time(start_beijing_time, start_timestamp, feed_time_shift):
    feed_time_shift_1 = feed_time_shift / 1000
    next_day = start_beijing_time + timedelta(days=1)
    print(col_y + f"\nПодача заявки на разблокировку загрузчика" + Fore.RESET)
    print(col_g + f"[Заданное смещение]: " + Fore.RESET + f"{feed_time_shift:.2f} мс.")
    target_time = next_day.replace(hour=0, minute=0, second=0, microsecond=0) - timedelta(seconds=feed_time_shift_1)
    print(col_g + f"[Ожидание до]: " + Fore.RESET + f"{target_time.strftime('%Y-%m-%d %H:%M:%S.%f')}")
    print(f"Не закрывайте окно...")
    
    while True:
        current_time = get_synchronized_beijing_time(start_beijing_time, start_timestamp)
        time_diff = target_time - current_time
        
        if time_diff.total_seconds() > 1:
            time.sleep(min(1.0, time_diff.total_seconds() - 1))
        elif current_time >= target_time:
            print(f"Время достигнуто: {current_time.strftime('%Y-%m-%d %H:%M:%S.%f')}. Начинаем отправку запросов...")
            break
        else:
            time.sleep(0.0001)

class HTTP11Session:
    def __init__(self):
        self.http = urllib3.PoolManager(
            maxsize=10,
            retries=True,
            timeout=urllib3.Timeout(connect=2.0, read=15.0),
            headers={}
        )

    def make_request(self, method, url, headers=None, body=None):
        try:
            request_headers = {}
            if headers:
                request_headers.update(headers)
                request_headers['Content-Type'] = 'application/json; charset=utf-8'
            
            if method == 'POST':
                if body is None:
                    body = '{"is_retry":true}'.encode('utf-8')
                request_headers['Content-Length'] = str(len(body))
                request_headers['Accept-Encoding'] = 'gzip, deflate, br'
                request_headers['User-Agent'] = 'okhttp/4.12.0'
                request_headers['Connection'] = 'keep-alive'
            
            response = self.http.request(
                method,
                url,
                headers=request_headers,
                body=body,
                preload_content=False
            )
            
            return response
        except Exception as e:
            print(f"[Ошибка сети] {e}")
            return None

def check_unlock_status(session, cookie_value, device_id):
    try:
        url = "https://sgp-api.buy.mi.com/bbs/api/global/user/bl-switch/state"
        headers = {
            "Cookie": f"new_bbs_serviceToken={cookie_value};versionCode=500423;versionName=5.4.23;deviceId={device_id};"
        }
        
        response = session.make_request('GET', url, headers=headers)
        if response is None:
            print(f"[Ошибка] Не удалось получить статус разблокировки.")
            return False

        response_data = json.loads(response.data.decode('utf-8'))
        response.release_conn()

        if response_data.get("code") == 100004:
            print(f"[Ошибка] Cookie устарел, требуется обновить!")
            return False

        data = response_data.get("data", {})
        is_pass = data.get("is_pass")
        button_state = data.get("button_state")
        deadline_format = data.get("deadline_format", "")

        if is_pass == 4:
            if button_state == 1:
                print(col_g + f"[Статус аккаунта]: " + Fore.RESET + f"подача заявки возможна.")
                return True
            elif button_state == 2:
                print(col_g + f"[Статус аккаунта]: " + Fore.RESET + f"блокировка на подачу до " f"{deadline_format} (Месяц/День).")
                status_2 = input(f"Продолжить (Yes/No)?: ")
                if status_2.lower() in ['y', 'yes']:
                    return True
                else:
                    return False
            elif button_state == 3:
                print(col_g + f"[Статус аккаунта]: " + Fore.RESET + f"аккаунт создан менее 30 дней назад.")
                status_3 = input(f"Продолжить (Yes/No)?: ")
                if status_3.lower() in ['y', 'yes']:
                    return True
                else:
                    return False
        elif is_pass == 1:
            print(col_g + f"[Статус аккаунта]: " + Fore.RESET + f"заявка одобрена, разблокировка возможна до " f"{deadline_format}.")
            return False
        else:
            print(col_g + f"[Статус аккаунта]: " + Fore.RESET + f"неизвестный статус.")
            return False
    except Exception as e:
        print(f"[Ошибка проверки статуса] {e}")
        return False

def run_aru(token_number):
    scriptversion = "UPR_S_v1.1"
    print(col_yb + f"{scriptversion}_токен_#{token_number}:")
    print(col_y + f"Проверка статуса аккаунта" + Fore.RESET)
    
    if not os.path.exists("token.txt"):
        print("Файл token.txt не найден!")
        return
    
    if not os.path.exists("timeshift.txt"):
        print("Файл timeshift.txt не найден!")
        return
    
    token = linecache.getline("token.txt", token_number).strip()
    if not token:
        print(f"Токен на строке {token_number} не найден!")
        return
    
    feedtime = float(linecache.getline("timeshift.txt", token_number).strip())
    
    cookie_value = token
    feed_time_shift = feedtime
    
    device_id = generate_device_id()
    session = HTTP11Session()

    if check_unlock_status(session, cookie_value, device_id):
        start_beijing_time = get_initial_beijing_time()
        if start_beijing_time is None:
            print(f"Не удалось установить начальное время.")
            return

        start_timestamp = time.time()
        
        wait_until_target_time(start_beijing_time, start_timestamp, feed_time_shift)

        url = "https://sgp-api.buy.mi.com/bbs/api/global/apply/bl-auth"
        headers = {
            "Cookie": f"new_bbs_serviceToken={cookie_value};versionCode=500423;versionName=5.4.23;deviceId={device_id};"
        }

        try:
            while True:
                request_time = get_synchronized_beijing_time(start_beijing_time, start_timestamp)
                print(col_g + f"[Запрос]: " + Fore.RESET + f"Отправка запроса в {request_time.strftime('%Y-%m-%d %H:%M:%S.%f')} (UTC+8)")
                
                response = session.make_request('POST', url, headers=headers)
                if response is None:
                    continue

                response_time = get_synchronized_beijing_time(start_beijing_time, start_timestamp)
                print(col_g + f"[Ответ]: " + Fore.RESET + f"Ответ получен в {response_time.strftime('%Y-%m-%d %H:%M:%S.%f')} (UTC+8)")

                try:
                    response_data = response.data
                    response.release_conn()
                    json_response = json.loads(response_data.decode('utf-8'))
                    code = json_response.get("code")
                    data = json_response.get("data", {})

                    if code == 0:
                        apply_result = data.get("apply_result")
                        if apply_result == 1:
                            print(col_g + f"[Статус]: " + Fore.RESET + f"Заявка одобрена, проверяем статус...")
                            check_unlock_status(session, cookie_value, device_id)
                        elif apply_result == 3:
                            deadline_format = data.get("deadline_format", "Не указано")
                            print(col_g + f"[Статус]: " + Fore.RESET + f"Заявка не подана, исчерпан лимит заявок, попробуйте снова в {deadline_format} (Месяц/День).")
                            return
                        elif apply_result == 4:
                            deadline_format = data.get("deadline_format", "Не указано")
                            print(col_g + f"[Статус]: " + Fore.RESET + f"Заявка не подана, выдана блокировка на подачу заявки до {deadline_format} (Месяц/День).")
                            return
                    elif code == 100001:
                        print(col_g + f"[Статус]: " + Fore.RESET + f"Заявка отклонена, ошибка запроса.")
                        print(col_g + f"[ПОЛНЫЙ ОТВЕТ]: " + Fore.RESET + f"{json_response}")
                    elif code == 100003:
                        print(col_g + f"[Статус]: " + Fore.RESET + f"Возможно заявка одобрена, проверяем статус...")
                        print(col_g + f"[Полный ответ]: " + Fore.RESET + f"{json_response}")
                        check_unlock_status(session, cookie_value, device_id)
                    elif code is not None:
                        print(col_g + f"[Статус]: " + Fore.RESET + f"Неизвестный статус заявки: {code}")
                        print(col_g + f"[Полный ответ]: " + Fore.RESET + f"{json_response}")
                    else:
                        print(col_g + f"[Ошибка]: " + Fore.RESET + f"Ответ не содержит необходимого кода.")
                        print(col_g + f"[Полный ответ]: " + Fore.RESET + f"{json_response}")

                except json.JSONDecodeError:
                    print(col_g + f"[Ошибка]: " + Fore.RESET + f"Не удалось декодировать JSON ответа.")
                except Exception as e:
                    print(col_g + f"[Ошибка обработки ответа]: " + Fore.RESET + f"{e}")
                    continue

        except Exception as e:
            print(col_g + f"[Ошибка запроса]: " + Fore.RESET + f"{e}")

# Функции из ATE
def extract_form_data(url):
    from urllib.parse import urlparse, parse_qs
    parsed = urlparse(url)
    query = parse_qs(parsed.query)
    return {key: value[0] for key, value in query.items()}

def ate_extract_tokens(username, password, token_count=1, delay=30):
    print(col_y + "Начинаем получение токенов..." + Fore.RESET)
    
    if not username or not password:
        print(col_r + "Ошибка: не заполнены логин или пароль" + Fore.RESET)
        return False
    
    # Очищаем старый файл токенов
    open("token.txt", 'w').close()
    
    success_count = 0
    
    for i in range(token_count):
        print(col_y + f"\nПолучение токена #{i+1} из {token_count}" + Fore.RESET)
        
        try:
            session = requests.Session()
            session.headers.update({
                "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36",
                "Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8",
                "Connection": "keep-alive",
                "Upgrade-Insecure-Requests": "1"
            })
            
            # Step 1: Go to global page
            session.get("https://c.mi.com/global", timeout=10)
            
            # Step 2: Get sign in page
            response = session.get(
                "https://sgp-api.buy.mi.com/bbs/api/global/user/login-in?callbackurl=https%3A%2F%2Fc.mi.com%2Fglobal%2F",
                allow_redirects=True,
                timeout=10
            )
            final_login_url = response.url
            
            # Extract form data
            form_data = extract_form_data(final_login_url)
            form_data['user'] = username
            form_data['hash'] = hashlib.md5(password.encode()).hexdigest().upper()
            
            # Step 3: Submit login form
            response = session.post(
                "https://account.xiaomi.com/pass/serviceLoginAuth2",
                data=form_data,
                allow_redirects=False,
                timeout=10
            )
            
            # Check for errors
            if response.status_code == 200:
                try:
                    auth_response = response.json()
                    if 'code' in auth_response and auth_response['code'] != 0:
                        error_msg = {
                            70016: "Неверный логин или пароль",
                            700010: "Неверный логин или пароль"
                        }.get(auth_response['code'], f"Ошибка сервера (код {auth_response['code']})")
                        print(col_r + f"Ошибка: {error_msg}" + Fore.RESET)
                        break
                except json.JSONDecodeError:
                    pass
            
            # Handle redirect
            if response.status_code != 302 or 'Location' not in response.headers:
                print(col_r + "Ошибка: Неверный логин или пароль" + Fore.RESET)
                break
            
            # Follow redirect
            redirect_url = response.headers['Location']
            session.get(redirect_url, allow_redirects=True, timeout=10)
            
            # Get cookies
            cookies = session.cookies.get_dict()
            
            # Check for token
            if 'new_bbs_serviceToken' not in cookies:
                print(col_r + "Ошибка: Не удалось получить токен авторизации" + Fore.RESET)
            else:
                # Save token to file
                token = cookies['new_bbs_serviceToken']
                with open("token.txt", 'a') as token_file:
                    token_file.write(token + '\n')
                
                success_count += 1
                print(col_g + f"✅ Токен получен: {token[:15]}..." + Fore.RESET)
            
            # Delay between requests
            if i < token_count - 1:
                print(col_y + f"Пауза {delay} сек. перед следующим запросом..." + Fore.RESET)
                time.sleep(delay)
                
        except Exception as e:
            print(col_r + f"Ошибка при получении токена: {str(e)}" + Fore.RESET)
    
    if success_count > 0:
        print(col_g + f"\nУСПЕШНО: Получено токенов: {success_count} из {token_count}" + Fore.RESET)
    else:
        print(col_r + f"\nНЕУДАЧА: Получено токенов: {success_count} из {token_count}" + Fore.RESET)
    
    return success_count > 0

def asc_calculate_shift(target_hour, target_minute, duration=30, factor=1.0):
    FIXED_TOKEN = "AaBbCc_chem.unlock"
    
    def get_local_time():
        return datetime.now()
    
    def wait_until_target_time(target_hour, target_minute):
        local_time = get_local_time()
        target_time = local_time.replace(
            hour=target_hour, minute=target_minute, second=0, microsecond=0)
        
        # Если указанное время уже прошло сегодня, переносим на завтра
        if target_time <= local_time:
            target_time += timedelta(days=1)
            print(col_y + f"Целевое время перенесено на завтра: {target_time.strftime('%d-%m-%Y %H:%M:%S')}" + Fore.RESET)
        else:
            print(col_y + f"Ожидание до: {target_time.strftime('%d-%m-%Y %H:%M:%S')}" + Fore.RESET)
        
        # Ожидаем до целевого времени
        while local_time < target_time:
            time.sleep(1)
            local_time = get_local_time()
            remaining = target_time - local_time
            hours, rem = divmod(int(remaining.total_seconds()), 3600)
            minutes, seconds = divmod(rem, 60)
            print(col_y + f"Осталось: {hours:02}:{minutes:02}:{seconds:02}" + Fore.RESET, end='\r')
        
        print("\n" + col_g + "Целевое время достигнуто! Начинаем измерения..." + Fore.RESET)
    
    def check_server_response_time():
        try:
            start_time = datetime.now()
            session = HTTP11Session()
            url = "https://sgp-api.buy.mi.com/bbs/api/global/user/bl-switch/state"
            headers = {
                "Cookie": f"new_bbs_serviceToken={FIXED_TOKEN};versionCode=500423;versionName=5.4.23;"
            }
            
            response = session.make_request('GET', url, headers=headers)
            end_time = datetime.now()
            
            if response is None:
                print(col_r + "Ошибка запроса статуса" + Fore.RESET)
                return 0

            response_data = json.loads(response.data.decode('utf-8', errors='ignore'))
            response.release_conn()

            time_diff = (end_time - start_time).total_seconds() * 1000

            result = (
                f"{col_g}Время отправки: {Fore.RESET}{start_time.strftime('%H:%M:%S.%f')[:-3]}\n"
                f"{col_g}Время получения: {Fore.RESET}{end_time.strftime('%H:%M:%S.%f')[:-3]}\n"
                f"{col_g}Суммарное время обработки запроса: {Fore.RESET}{time_diff:.2f} мс"
            )
            print(result)
            return time_diff

        except Exception as e:
            print(col_r + f"Ошибка: {str(e)}" + Fore.RESET)
            return 0
    
    def ping_ip(ip, duration):
        try:
            if sys.platform.startswith('win'):
                command = ['ping', '-n', str(duration), '-w', '2000', ip]
                creation_flags = subprocess.CREATE_NO_WINDOW
            else:
                command = ['ping', '-w', str(duration), '-c', str(duration), ip]
                creation_flags = 0

            process = subprocess.Popen(
                command,
                stdout=subprocess.PIPE,
                stderr=subprocess.PIPE,
                text=True,
                bufsize=1,
                universal_newlines=True,
                encoding='cp866' if sys.platform.startswith('win') else 'utf-8',
                errors='replace',
                creationflags=creation_flags
            )

            times = []
            start_time = time.time()
            end_time = start_time + duration + 5

            print(col_y + f"Пинг IP {ip}..." + Fore.RESET)
            
            while time.time() < end_time:
                line = process.stdout.readline()
                if not line:
                    break
                
                match = re.search(
                    r'(время[=<]|time[=<]|время\s*=\s*)(\d+\.?\d*)\s*м?s?', 
                    line, 
                    re.IGNORECASE
                )
                if match:
                    try:
                        t = float(match.group(2))
                        times.append(t)
                    except:
                        pass
            
            if process.poll() is None:
                process.kill()

            if not times:
                print(col_r + f"{ip} - Нет ответа" + Fore.RESET)
                return 0, 0, 0

            min_ping = round(min(times), 2)
            avg = round(sum(times) / len(times), 2)
            max_ping = round(max(times), 2)
            
            print(col_g + f"Пинг IP {ip}: мин {min_ping}мс, среднее {avg}мс, макс {max_ping}мс" + Fore.RESET)
            return min_ping, avg, max_ping

        except Exception as e:
            print(col_r + f"Ошибка: {str(e)}" + Fore.RESET)
            return 0, 0, 0
    
    def save_timeshift(scores):
        sorted_scores = sorted([scores['score1'], scores['score2'], scores['score3'], scores['score4']])
        with open("timeshift.txt", "w", encoding="utf-8") as f:
            for val in sorted_scores:
                f.write(f"{val:.2f}\n")
        print(col_g + "Результаты сохранены в файл timeshift.txt" + Fore.RESET)
    
    # Основная логика ASC
    print(col_y + f"Ожидание указанного времени: {target_hour:02}:{target_minute:02}" + Fore.RESET)
    wait_until_target_time(target_hour, target_minute)
    
    print(col_y + "Проверка времени обработки запроса сервером..." + Fore.RESET)
    time_diff = check_server_response_time()
    
    print(col_y + "Начинаем пинг..." + Fore.RESET)
    results = []
    ips = ["161.117.95.164", '161.117.96.161']
    
    for ip in ips:
        min_ping, avg, max_ping = ping_ip(ip, duration)
        results.append((min_ping, avg, max_ping))
    
    if not any(results):
        print(col_r + "Не удалось получить результаты пинга" + Fore.RESET)
        return False
    
    total_avg = sum(r[1] for r in results)/len(results)
    serv_time = time_diff - total_avg
    final_score_1 = serv_time + total_avg/2
    final_score_2 = serv_time/2 + total_avg/2
    final_score_3 = (final_score_1 + final_score_2)/2
    final_score_4 = (final_score_1 + final_score_3)/2
    
    base_scores = {
        'score1': final_score_1,
        'score2': final_score_2,
        'score3': final_score_3,
        'score4': final_score_4,
        'total_avg': total_avg,
        'serv_time': serv_time
    }
    
    # Применяем коэффициент коррекции
    recalculated = {
        'score1': base_scores['score1'] * factor,
        'score2': base_scores['score2'] * factor,
        'score3': base_scores['score3'] * factor,
        'score4': base_scores['score4'] * factor
    }
    
    print("\n" + col_g + "Результаты расчета:" + Fore.RESET)
    print(col_g + f"Средний пинг: {Fore.RESET}{total_avg:.2f} мс")
    print(col_g + f"Время обработки запроса сервером: {Fore.RESET}{serv_time:.2f} мс")
    print(col_g + f"Смещение #1: {Fore.RESET}{recalculated['score1']:.2f} мс")
    print(col_g + f"Смещение #2: {Fore.RESET}{recalculated['score2']:.2f} мс")
    print(col_g + f"Смещение #3: {Fore.RESET}{recalculated['score3']:.2f} мс")
    print(col_g + f"Смещение #4: {Fore.RESET}{recalculated['score4']:.2f} мс")
    
    save_timeshift(recalculated)
    return True

# Главное меню
def main_menu():
    while True:
        clear_screen()
        print("\n" + "="*50)
        print(col_yb + "Главное меню" + Fore.RESET)
        print("1. Получить токены (ATE)")
        print("2. Рассчитать смещение (ASC)")
        print("3. Подать заявку (UPR)")
        print("0. Выход")
        
        choice = input("Выберите действие: ")
        
        if choice == "1":
            clear_screen()
            print("\n" + "="*50)
            print(col_y + "Получение токенов" + Fore.RESET)
            username = input("Email/Телефон/ID: ")
            password = input("Пароль: ")
            token_count = input("Количество токенов (по умолчанию 1): ")
            delay = input("Задержка между запросами в секундах (по умолчанию 30): ")
            
            try:
                token_count = int(token_count) if token_count else 1
                delay = int(delay) if delay else 30
            except ValueError:
                print(col_r + "Ошибка: введите числовые значения" + Fore.RESET)
                time.sleep(2)
                continue
                
            ate_extract_tokens(username, password, token_count, delay)
            input("\nНажмите Enter для продолжения...")
            
        elif choice == "2":
            clear_screen()
            print("\n" + "="*50)
            print(col_y + "Расчет смещения" + Fore.RESET)
            hour = input("Час (0-23): ")
            minute = input("Минута (0-59): ")
            duration = input("Длительность пинга в секундах (по умолчанию 30): ")
            factor = input("Коэффициент коррекции (по умолчанию 1.0): ")
            
            try:
                hour = int(hour)
                minute = int(minute)
                duration = int(duration) if duration else 30
                factor = float(factor) if factor else 1.0
                
                if not (0 <= hour <= 23 and 0 <= minute <= 59):
                    print(col_r + "Ошибка: неверное время" + Fore.RESET)
                    time.sleep(2)
                    continue
                    
            except ValueError:
                print(col_r + "Ошибка: введите числовые значения" + Fore.RESET)
                time.sleep(2)
                continue
                
            asc_calculate_shift(hour, minute, duration, factor)
            input("\nНажмите Enter для продолжения...")
            
        elif choice == "3":
            clear_screen()
            print("\n" + "="*50)
            #print(col_y + "Получение разрешения" + Fore.RESET)
            
            if not os.path.exists("token.txt"):
                print(col_r + "Файл token.txt не найден! Сначала получите токены." + Fore.RESET)
                time.sleep(2)
                continue
                
            if not os.path.exists("timeshift.txt"):
                print(col_r + "Файл timeshift.txt не найден! Сначала рассчитайте смещение." + Fore.RESET)
                time.sleep(2)
                continue
                
            token_number = input("Номер строки токена (начиная с 1): ")
            
            try:
                token_number = int(token_number)
                clear_screen()
                run_aru(token_number)
            except ValueError:
                print(col_r + "Ошибка: введите числовое значение" + Fore.RESET)
                time.sleep(2)
                
            input("\nНажмите Enter для продолжения...")
                
        elif choice == "0":
            print("Выход...")
            break
            
        else:
            print(col_r + "Неверный выбор" + Fore.RESET)
            time.sleep(1)

if __name__ == "__main__":
    # Запускаем главное меню
    main_menu()